<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('process_notification_settings', function (Blueprint $table) {
            $table->unsignedInteger('process_id');
            $table->string('element_id')->nullable();
            $table->string('notifiable_type');
            $table->string('notification_type');

            $table->foreign('process_id')->references('id')->on('processes');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('process_notification_settings');
    }
};
