<!doctype html>
<html lang="en">
  <head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/css/bootstrap.min.css" integrity="sha384-ggOyR0iXCbMQv3Xipma34MD+dH/1fQ784/j6cY/iJTQUOhcWr7x9JvoRxT2MZw1T" crossorigin="anonymous">

    <title>Model Factories Performance</title>
  </head>
  <body>
    
    <table class="table table-sm table-hover">
        <thead>
          <tr>
            <th scope="col">Model</th>
            <th scope="col" class="text-right">Average time [ms]</th>
            <th scope="col" class="text-right">Models created per second</th>
            <th scope="col" class="text-right">DB rows created per factory</th>
            <th scope="col" class="text-right">Weighted speed</th>
          </tr>
        </thead>
        <tbody>
<?php foreach ($measurements as $measure): ?>
          <tr>
            <th class="<?=$measure['color']?>" scope="row"><?=$measure['model']?></th>
            <td class="<?=$measure['color']?> text-right"><?=$measure['time']?></td>
            <td class="<?=$measure['color']?> text-right"><?=$measure['factorySpeed']?></td>
            <td class="<?=$measure['color']?> text-right"><?=$measure['recordsPerFactory']?></td>
            <td class="<?=$measure['color']?> text-right"><?=$measure['speed']?></td>
          </tr>
<?php endforeach; ?>
        </tbody>
      </table>

    <!-- Optional JavaScript -->
    <!-- jQuery first, then Popper.js, then Bootstrap JS -->
    <script src="https://code.jquery.com/jquery-3.3.1.slim.min.js" integrity="sha384-q8i/X+965DzO0rT7abK41JStQIAqVgRVzpbzo5smXKp4YfRvH+8abtTE1Pi6jizo" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.14.7/umd/popper.min.js" integrity="sha384-UO2eT0CpHqdSJQ6hJty5KVphtPhzWj9WO1clHTMGa3JDZwrnQq4sF86dIHNDz0W1" crossorigin="anonymous"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.min.js" integrity="sha384-JjSmVgyd0p3pXB1rRibZUAYoIIy6OrQ6VrjIEaFf/nJGzIxFDsf4x0xIM+B07jRM" crossorigin="anonymous"></script>
  </body>
</html>
