<?php

namespace ProcessMaker\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use ProcessMaker\Facades\Metrics;
use ProcessMaker\Managers\DataManager;
use ProcessMaker\Models\Process as Definitions;
use ProcessMaker\Models\ProcessRequestToken;
use ProcessMaker\Nayra\Contracts\Bpmn\ActivityInterface;
use ProcessMaker\Nayra\Contracts\Bpmn\TokenInterface;
use ProcessMaker\Nayra\Contracts\Engine\ExecutionInstanceInterface;

class CompleteActivity extends BpmnAction implements ShouldQueue
{
    public $definitionsId;

    public $instanceId;

    public $tokenId;

    public $data;

    /**
     * Create a new job instance.
     *
     * @return void
     */
    public function __construct(Definitions $definitions, ExecutionInstanceInterface $instance, TokenInterface $token, array $data)
    {
        $this->definitionsId = $definitions->getKey();
        $this->instanceId = $instance->getKey();
        $this->tokenId = $token->getKey();
        $this->data = $data;
    }

    /**
     * Execute the job.
     *
     * @return void
     */
    public function action(ProcessRequestToken $token, ActivityInterface $element, array $data)
    {
        //@todo requires a class to manage the data access and control the updates
        $manager = new DataManager();
        $manager->updateData($token, $data);
        $this->engine->runToNextState();
        $element->complete($token);

        Metrics::counterInc(
            'activity_completed_total',
            'Total number of activities completed',
            [
                'activity_id' => $element->getId(),
                'activity_name' => $element->getName(),
                'process_id' => $this->definitionsId,
                'request_id' => $this->instanceId,
            ]
        );
    }
}
